#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  Hopf fibersMod01.fsh    by   tmst    
//https://www.shadertoy.com/view/ttVXWt
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14159

#define FIXED_UP vec3(0.,1.,0.)
#define TAN_HFOVY .5773502691896257

#define GE1 vec3(.04,0.,0.)
#define GE2 vec3(0.,.04,0.)
#define GE3 vec3(0.,0.,.04)
#define STEP_D .04

#define RES iResolution
#define MS iMouse
#define PHASE smoothstep(.2, .8, MS.z > 0. ? MS.y/RES.y : .5+.5*cos(.4*iTime))
#define ANG (MS.z > 0. ? 2.*PI*MS.x/RES.x : PI + 1.5*iTime)

// ================
// Generic helpers
// ================

float square(float x) { return x*x; }

float rand(vec2 p) {
    return fract(sin(dot(p,vec2(12.9898,78.233))) * 43758.5453);
}

vec3 nvCamDirFromClip(vec3 nvFw, vec2 c) {
    vec3 nvRt = normalize(cross(nvFw, FIXED_UP));
    vec3 nvUp = cross(nvRt, nvFw);
    return normalize(TAN_HFOVY*(c.x*(RES.x/RES.y)*nvRt + c.y*nvUp) + nvFw);
}

// Rodrigues' formula: v -> (v.n)n + (v-(v.n)n)c - (vxn)s
mat3 oProd(vec3 n) {
    float xy = n.x*n.y, xz = n.x*n.z, yz = n.y*n.z;
    return mat3(n.x*n.x,xy,xz,  xy,n.y*n.y,yz,  xz,yz,n.z*n.z);
}
mat3 glRotate(vec3 axis, float angle) {
    float c = cos(angle), s = sin(angle);
    vec3 n = normalize(axis);
    return (
        (1.-c)*oProd(n) +
        mat3(c,s*n.z,-s*n.y,  -s*n.z,c,s*n.x,  s*n.y,-s*n.x,c)
	);
}

// Colormap adapted from: iq - Palettes (https://www.shadertoy.com/view/ll2GD3)
vec3 colormap(float t) {
    return .5 + .5*cos(2.*PI*( t + vec3(0.,.1,.2) ));
}

// ==================
// Volume definition
// ==================

vec3 hopf(vec3 p) {
	// inverse stereographic R^3 -> S^3
    float psq = dot(p, p);
    vec4 q = vec4(2.*p.xyz, -1. + psq) / (1. + psq);

    // hopf map S^3 -> S^2 (map versor q -> qjq*, i.e., rotate j using q)
    return vec3(
        2.*(q.y*q.z - q.x*q.w),
        1. - 2.*(q.y*q.y + q.w*q.w), // == q.x^2 - q.y^2 + q.z^2 - q.w^2
        2.*(q.x*q.y + q.z*q.w)
    );
}

vec4 getV(vec3 p, mat3 m) {
    // Get point on S^2, and rotate it for visual effect
    vec3 rp = m * hopf(p);

    // Fixed y == union of linked circles of same radii (interp. by theta)
	float theta = atan(-rp.z, rp.x);
    float sdy = square(.5 + .5*cos(rp.y*5.*PI));
    float sdt = .5 + .5*sin(theta*20.);
    float d1 = max(sdt*sdy, .55*sdy);
    d1 = mix(d1, .8*sdy, PHASE); // Sampling from a cubemap here is interesting

    return vec4(.5 + .5*rp.y, 0., 0., d1);
}

vec4 getC(vec3 p, vec3 camPos, mat3 m) {
    // Quick exit if volume has low alpha
    vec4 data0 = getV(p, m);
    if (data0.a < .4) { return vec4(0.); }

    // Normal
    vec3 gradA = vec3(
        getV(p + GE1, m).a - getV(p - GE1, m).a,
        getV(p + GE2, m).a - getV(p - GE2, m).a,
        getV(p + GE3, m).a - getV(p - GE3, m).a
    );
    vec3 normal = (-gradA/(length(gradA) + 1e-5));

    // Material color with lighting
    vec3 matColor = mix(colormap(data0.r), .5+.5*normal.xyz, .25);
    vec3 lightPos = camPos + vec3(0., 1., 0.);
    vec3 nvFragToLight = normalize(lightPos - p);
    vec3 nvFragToCam = normalize(camPos - p);

	vec3 diffuse = clamp(dot(normal, nvFragToLight), 0., 1.) * matColor;
    vec3 blinnH = normalize(nvFragToLight + nvFragToCam);
    vec3 specular = pow(clamp(dot(normal, blinnH), 0., 1.), 60.) * vec3(1.);

    return vec4(.4*matColor+.6*(diffuse+specular), pow(data0.w, 3.));
}

// =============
// Render scene
// =============

void march(in vec3 p, in vec3 nv, out vec4 color) {
    color = vec4(0.);
    vec2 tRange = vec2(mix(1., 2.75, PHASE), 6.);

	mat3 m = glRotate( normalize(vec3(1.,sin(iTime),1.)), -ANG );

    float t = tRange.s;
    for (int i=0; i<250; i++) {
        vec4 cHit = getC(p + t*nv, p, m);

        vec4 ci = vec4(cHit.rgb, 1.)*( (STEP_D/.08)*cHit.a ); // Premul alpha
        color += (1.-color.a)*ci;

        t += STEP_D;
        if (t > tRange.t || color.a > .95) { return; }
    }
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord/RES.xy;
    vec3 camPos = vec3(0., 1., 3.5);
    vec3 nvCamDir = nvCamDirFromClip(normalize(-camPos), uv*2. - 1.);

    vec4 objColor;
    march(camPos + rand(fragCoord)*nvCamDir*STEP_D, nvCamDir, objColor);
    vec3 finalColor = objColor.rgb + (1. - objColor.a)*vec3(.2);

    fragColor = vec4(finalColor, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

